import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:rounded_loading_button_plus/rounded_loading_button.dart';
import 'package:wordpress_app/blocs/user_bloc.dart';
import 'package:wordpress_app/pages/welcome.dart';
import 'package:wordpress_app/utils/next_screen.dart';

import '../utils/toast.dart';

class DeleteSocialUser extends ConsumerStatefulWidget {
  const DeleteSocialUser({super.key});

  @override
  ConsumerState<DeleteSocialUser> createState() => _DeleteSocialUserState();
}

class _DeleteSocialUserState extends ConsumerState<DeleteSocialUser> {


  final _btnCtlr = RoundedLoadingButtonController();

  

  Future<void> _handleDeleteAccount() async {
    final UserBloc ub = ref.read(userBlocProvider);
    _btnCtlr.start();
    await ub.userSignout().then((value){
      Future.delayed(const Duration(seconds: 1)).then((value){
        _btnCtlr.success();
        openToast('Account deleted successfully!');
        Future.delayed(const Duration(seconds: 1)).then((value){
          if (!mounted) return;
          Navigator.pop(context);
          nextScreenCloseOthersAnimation(context, const WelcomePage());
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding:
          EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
      child: Container(
        height: 150,
        alignment: Alignment.center,
        padding: const EdgeInsets.fromLTRB(30, 30, 30, 20),
        child: RoundedLoadingButton(
          animateOnTap: false,
          controller: _btnCtlr,
          elevation: 0,
          color: Theme.of(context).primaryColor,
          onPressed: () => _handleDeleteAccount(),
          child: Text(
            'account-delete-confirm',
            style: Theme.of(context)
                .textTheme
                .titleMedium
                ?.copyWith(color: Theme.of(context).colorScheme.onPrimary, fontWeight: FontWeight.w600),
          ).tr(),
        ),
      ),
    );
  }
}
